 aR  w Q m^9      h	 oP     nSystem-wide$NOLIST

	NAME	Utils

; This is utils.asm.  This file contains a number of misc routines

PUBLIC MsExit
PUBLIC Glitch
PUBLIC DoNothing
PUBLIC NextFreeBlock
PUBLIC CpGetMemSize
PUBLIC GetBootDevice
PUBLIC MsDosLineOut
PUBLIC MsDosCharIn
PUBLIC PatchDOSInterrupts

PUBLIC WaitOnMsDosSema
PUBLIC SignalMsDosSema
PUBLIC DosDiskCallGRiDError

PUBLIC msDosUserPid
PUBLIC msDosDepth

PUBLIC OldHDiskIntPatch
PUBLIC MySumBufferBytes

PUBLIC EmsPatchStart
PUBLIC EmsPatchTable


EXTRN ConLineOut: NEAR
EXTRN CpWait: FAR
EXTRN CpSignal: FAR
EXTRN CpWhoAmI: FAR
EXTRN CpSetActiveSlot: FAR
EXTRN OsExit: FAR

EXTRN SaveGRiDInts: FAR
EXTRN RestoreDosInts: FAR
EXTRN RestoreGRiDInts: FAR

EMS_CGROUP GROUP EMS_CODE
Sysdep_CGROUP GROUP Sysdep_CODE
Sysdep_DGROUP GROUP Sysdep_DATA
CGROUP GROUP CODE

SYSDEP_DATA	SEGMENT	PUBLIC 'DATA'
  EXTRN curSlot: BYTE
  EXTRN romsExecute: BYTE
  EXTRN msDosSema: WORD

  EXTRN oldHDiskInt: DWORD
  EXTRN oldHDiskIntUsed: BYTE

  EXTRN loaderChecksum: BYTE

  msDosUserPid DW 1 DUP (?)
  msDosDepth   DW 1 DUP (?)

ASSUME CS:SYSDEP_DGROUP

OldHDiskIntPatch PROC FAR
  OR  SYSDEP_DGROUP:oldHDiskIntUsed, 1
  JMP DWORD PTR SYSDEP_DGROUP:oldHDiskInt
OldHDiskIntPatch ENDP

ASSUME CS:NOTHING

SYSDEP_DATA ENDS


CODE	SEGMENT	PUBLIC 'CODE'
	ASSUME	CS:CGROUP

  EXTRN  WaitOnDosSemaGiveMem: FAR
  EXTRN  TakeMemSignalDosSema: FAR

CODE ENDS


Sysdep_CODE	SEGMENT	PUBLIC 'CODE'
	ASSUME	CS:Sysdep_CGROUP
$EJECT

; general

FALSE             EQU 0
TRUE              EQU 1
fnCallInt         EQU 21H

; GRiD error codes

eOk               EQU 0
eOutOfMem         EQU 2
eInvMemBlock      EQU 11
eCheckSum         EQU 29
eBadPointer       EQU 31
eFileNotFound     EQU 33
eAccess           EQU 38

eInvalidDrive     EQU 101
eInvalidSector    EQU 102
eCrcData          EQU 103
eRecordNotFound   EQU 104
eCrcID            EQU 105
eWriteProtect     EQU 106
eDevNotReady      EQU 107
eOther            EQU 108

eCrossFS          EQU 220
eBadConn          EQU 221
eParam            EQU 225
eBadPath          EQU 227
eInvBitMap        EQU 233
eInvMedia         EQU 235
eTooManyFilesOpen EQU 238

; MsDos error codes

eMsOK             EQU 0
eMsInvalidParm    EQU 1
eMsFileNotFound   EQU 2
eMsPathNotFound   EQU 3
eMsTooManyOpen    EQU 4
eMsAccessDenied   EQU 5
eMsInvalidConn    EQU 6
eMsMemoryTrashed  EQU 7
eMsOutOfMemory    EQU 8
eMsInvalidBlock   EQU 9
eMsBadEnvironment EQU 10
eMsBadFormat      EQU 11
eMsInvalidAccess  EQU 12
eMsInvalidData    EQU 13
eMsInvalidDrive   EQU 15
eMsDirectoryInUse EQU 16
eMsNotSameDevice  EQU 17
eMsNoMoreFiles    EQU 18

; Variables in Code Segment

int24ErrorCode    DB ?
lastCall          DB ?
stackSS           DW ?
stackSP           DW ?


; Constants in Code Segment

; The index into this error table represents the MsDos Xnx Error Code (0-18)
; The value at that index is the closest GRiD-OS error translatable.
; If you don't know what the num in the table means then use OsDecodeException.

; This table has been set up with these things in mind-
;  - it doesn't expect to get the error code 0
;  - it translates eMsNoMoreFiles to 0 (eOK) on purpose
;  - there is no error number 14 (As defined by Microsoft).
;  - The errors for the load command are translated to eBadPath

msToGRiDErrors DB eOK               ; for eMsOK
               DB eParam            ; for eMsInvalidParm
               DB eFileNotFound     ; for eMsFileNotFound
               DB eFileNotFound     ; for eMsPathNotFound
               DB eTooManyFilesOpen ; for eMsTooManyOpen
               DB eAccess           ; for eMsAccessDenied
               DB eBadConn          ; for eMsInvalidConn
               DB eBadPointer       ; for eMsMemoryTrashed
               DB eOutOfMem         ; for eMsOutOfMemory
               DB eInvMemBlock      ; for eMsInvalidBlock
               DB eBadPath          ; for eMsBadEnvironment
               DB eBadPath          ; for eMsBadFormat
               DB eParam            ; for eMsBadAccess
               DB eParam            ; for eMsInvalidData
               DB eOK               ; for undefined error code
               DB eParam            ; for eMsInvalidDrive
               DB eAccess           ; for eMsDirectoryInUse
               DB eCrossFS          ; for eMsNotSameDevice
               DB eOK               ; for eMsNoMoreFiles (returns numRead = 0)


; These tables are used with the Int24 error handler routine

blkToGRiDErrs  DB eWriteProtect       ; for write protected
               DB eInvalidDrive       ; for unknown unit
               DB eDevNotReady        ; for drive not ready
               DB eOther              ; for unknown command
               DB eCrcData            ; for data error
               DB eParam              ; for bad request length
               DB eInvalidSector      ; for seek error
               DB eInvMedia           ; for unknown media type
               DB eInvalidSector      ; for sector not found
               DB eDevNotReady        ; for printer out of paper
               DB eCrcData            ; for write fault
               DB eCrcData            ; for read fault
               DB eDevNotReady        ; for general fault

charToGRiDErrs DB eWriteProtect       ; for write protected
               DB eInvalidDrive       ; for unknown unit
               DB eDevNotReady        ; for drive not ready
               DB eOther              ; for unknown command
               DB eDevNotReady        ; for data error
               DB eParam              ; for bad request length
               DB eDevNotReady        ; for seek error
               DB eDevNotReady        ; for unknown media type
               DB eDevNotReady        ; for sector not found
               DB eDevNotReady        ; for printer out of paper
               DB eDevNotReady        ; for write fault
               DB eDevNotReady        ; for read fault
               DB eDevNotReady        ; for general fault
$EJECT

;   CpGetMemSize: PROCEDURE WORD CLEAN;
;
;  This routine will get the memory size of the system.
;  It will return in the AX reg the # of k's. This routine
;  will round up to the nearest 16k.
;

CpGetMemSize PROC FAR
  INT    12h              ; Get the memory Size.
  MOV    BX, AX
  AND    AX, 0FFF0h       ; mask out lower 16k value
  AND    BX, 0Fh          ; were any bits set in lower 16k?
  JZ     RoundNum
  ADD    AX, 10h          ; round up to next 16k
RoundNum:
;  MOV    CX, DGROUP
  MOV    CX, SYSDEP_DGROUP
  MOV    ES, CX
  TEST   ES:romsExecute, 1
  JZ     CpGetMemDone
  CMP    AX, 512
  JBE    CpGetMemDone
  MOV    AX, 512         ; With GRiD Roms, only 512k of memory is usable
CpGetMemDone:
  RET
CpGetMemSize ENDP
$EJECT

;   NextFreeBlock: PROCEDURE WORD CLEAN;
;
;    This routine returns the address of the next available memory block
;    from MsDos.  Its only purpose is to see if InteGRiD is loaded near
;    8000H, which is a problem when ROMs are used.

NextFreeBlock PROC NEAR
  MOV  BX, 1                     ; Allocate smallest block possible
  MOV  AH, 48H
  INT  fnCallInt
  JNC  FreeNextFreeBlock

  MOV  AX, 0FFFFH                ; If error then
  RET                            ;   RETURN (0FFFFH)

FreeNextFreeBlock:
  PUSH AX
  MOV  ES, AX
  MOV  AH, 49H                   ; Free the memory block
  INT  fnCallInt
  POP  AX                        ; RETURN (@next block)
  RET
NextFreeBlock ENDP
$EJECT

;  MsDosLineOut: PROCEDURE (pBuf, len) CLEAN;
;    DCL len    WORD;
;    DCL pBuf   PTR;
;    END;
;
Params  STRUC
;--------------
  oldBP    DW ?
  oldDS    DW ?
  longRet  DD ?
;--------------
  len      DW ?
  OffOfBuf DW ?
  SegOfBuf DW ?
params ENDS

parm EQU [BP]

MsDosLineOut PROC FAR
  PUSH   DS
  PUSH   BP
  MOV    BP, SP
  MOV    CX, parm.len
  MOV    DS, parm.SegOfBuf
  MOV    SI, parm.OffOfBuf

TopALoop:
  MOV    AL, BYTE PTR DS:[SI]
  INC    SI
  MOV    BX, 3
  MOV    AH, 14
  INT    10h         ; This may destroy BP
  LOOP   TopALoop

  POP    BP
  POP    DS
  RET    6
MsDosLineOut ENDP
PURGE parm
PURGE params
PURGE len
PURGE SegOfBuf
PURGE OffOfBuf
PURGE oldBP
PURGE oldDS
PURGE longRet
$EJECT

; 
;  MsDosCharIn: PROCEDURE WORD CLEAN;
;    END;
;

MsDosCharIn PROC FAR
  PUSH   DS
  PUSH   BP

  MOV    AH, 7
  INT    21H

  POP    BP
  POP    DS
  RET
MsDosCharIn ENDP
$EJECT

;***********************************************************
;
; NMI Interrupt Handler
;
;***********************************************************

;PPIC   EQU 62h
;IOCHK  EQU 40h
;PARCHK EQU 80h

;NMI PROC NEAR
;  MOV  SI,OFFSET NMIMSG1
;  IN   AL,PPIC
;  AND  AL,IOCHK+PARCHK        ; I/O Channel Check or
;                              ;   RAM Parity Check ?
;  JNZ   NMIIN0                ; It wasn't either, probably the 8087 or keyboard
;  IRET                        ; just return...
;NMIIN0:
;  JS   NMIIN1                 ; It was a memory parity
;  MOV  SI,OFFSET NMIMSG0      ; It was an I/O memory board parity
;NMIIN1:
;  PUSH CS
;  MOV  BL, BYTE PTR CS:[SI]
;  MOV  BH, 0
;  INC  SI
;  PUSH SI
;  PUSH BX
;  CALL ConLineOut             ; Write error message to CRT
;NMIIN3:
;  JMP  NMIIN3
;
;NMIMSG0:
;  DB   16, ' I/O Board NMI',0dh,0ah
;NMIMSG1:
;  DB   21, ' Memory Parity NMI',0dh,0ah
;NMI  ENDP

;***********************************************************
;
; Glitch Interrupt
;
;***********************************************************

Glitch PROC FAR
  PUSH AX
  MOV  AL, 20h    ; Non specific EOI
  OUT  20h, AL    ; out to the 8259
  POP  AX
DoNothing PROC FAR
  IRET
DoNothing ENDP
Glitch ENDP
$EJECT

;
;   WaitOnMsDosSema: PROCEDURE
;
;

WaitOnMsDosSema PROC FAR
  PUSH BP
  PUSH CX                   ; error local
  MOV  BP, SP

  CALL CpWhoAmI
  MOV  BX, SYSDEP_DGROUP
  MOV  ES, BX
  PUSH ES                   ; Save SYSDEP_DGROUP for later
  CMP  AX, ES:MsDosUserPid
  JE   WaitOnSemaRet        ; IF MsDosUserPid <> CpWhoAmI THEN

  PUSH AX                   ;   DO;
  PUSH ES

  MOV  AX, ES:MsDosSema     
  PUSH AX
  MOV  AX, 0FFFFh
  PUSH AX
  PUSH SS
  PUSH BP
  CALL CpWait               ;   CALL CpWait (msDosSema, NULLWORD, @error);

  POP  ES
  POP  ES:MsDosUserPid      ;   MsDosUserPid = CpWhoAmI;
  MOV  ES:MsDosDepth, 0     ;   MsDosDepth = 0;
                            ;   END;
  MOV  AX, SYSDEP_DGROUP
  MOV  ES, AX
  TEST ES:romsExecute, 1
  JZ   WaitOnSemaRet        ; If there are no GRiD Roms don't disable ROMS

  MOV  AL, ES:curSlot
  OR   AL, 80H
  PUSH AX                   ; Disable Roms when entering Ms-DOS. 
  CALL CpSetActiveSlot      ; This is required for 640k systems

WaitOnSemaRet:
  POP  ES                   ; ES => SYSDEP_DGROUP
  INC  ES:MsDosDepth        ; MsDosDepth = MsDosDepth + 1;

  POP  CX                   ; error local
  POP  BP
  RET
WaitOnMsDosSema ENDP
$EJECT

;
;   SignalMsDosSema: PROCEDURE
;
;

SignalMsDosSema PROC FAR
  PUSH BP
  PUSH CX                   ; error local
  MOV  BP, SP

  MOV  AX, SYSDEP_DGROUP
  MOV  ES, AX

  DEC  ES:MsDosDepth        ; MsDosDepth = MsDosDepth - 1;
  JNZ  SignalSemaRet        ; IF MsDosDepth = 0 THEN
                            ;   DO;
  MOV  ES:MsDosUserPid, 0FFFFh 
                            ;   MsDosUserPid = NULLWORD;
  MOV  AX, ES:MsDosSema
  PUSH AX
  MOV  AX, 1
  PUSH AX
  MOV  AX, 0
  PUSH AX
  PUSH SS
  PUSH BP
  CALL CpSignal             ;   CALL CpSignal (msDosSema, signalNormal, 0, 
                            ;                  @error);
                            ;   END;
  MOV  AX, SYSDEP_DGROUP    ; Now enable the ROMS
  MOV  ES, AX
  TEST ES:romsExecute, 1
  JZ   SignalSemaRet        ; If there are no GRiD Roms don't enable ROMS

  MOV  AL, ES:curSlot
  CMP  AL, 0FEH             ; If current slot is invalid slot
  JAE  SignalSemaRet        ; then don't wreck it by anding with 7FH

  AND  AL, 7Fh              ; Reset to enable Roms
  PUSH AX
  CALL CpSetActiveSlot      ; set the active slot

SignalSemaRet:
  POP  CX                   ; error local
  POP  BP
  RET
SignalMsDosSema ENDP
$EJECT

;   MsDosFunctionInterrupt: PROCEDURE INTERRUPT;
;
; This is a patch for the MS-DOS function interrupt 21h.
;

oldMsDosInterruptOff DW ?
oldMsDosInterruptSeg DW ?

MsDosFunctionInterrupt PROC FAR
  PUSH BX
  MOV  BX, SP
  MOV  BX, SS:[BX+6]        ; get the flags parm
  PUSH BX
  POPF                      ; ints may be enabled
  POP  BX

  PUSHF                     ; Flags for the Int 21 call
  CMP  AH, 4bh              ; is this a Exec call ?
  JE   JmpToMsDos           ; yes, bypass this call
  CMP  AH, 26h              ; is this an old Exec call ?
  JE   JmpToMsDos           ; yes, bypass this call
  CMP  AH, 4ch              ; is this an MsExit call?
  JE   JmpToMsDos           ; yes, bypass this call
  CMP  AH, 0                ; is this an old MsExit call?
  JNE  CheckCounter         ; yes, bypass this call

JmpToMsDos:
  POPF                      ; get rid of flags
  JMP  DWORD PTR Sysdep_CGROUP:oldMsDosInterruptOff   ; go to the old interrupt

CheckCounter:
  PUSH AX
  PUSH BX
  PUSH CX
  PUSH DX
  PUSH SI
  PUSH DI
  PUSH ES

  CALL WaitOnMsDosSema

  POP  ES
  POP  DI
  POP  SI
  POP  DX
  POP  CX
  POP  BX
  POP  AX

MakeDOSCall:
  CALL DWORD PTR Sysdep_CGROUP:oldMsDosInterruptOff   ; go to the old interrupt

  PUSHF
  PUSH AX
  PUSH BX
  PUSH CX
  PUSH DX
  PUSH SI
  PUSH DI
  PUSH ES

  CALL SignalMsDosSema

  POP  ES
  POP  DI
  POP  SI
  POP  DX
  POP  CX
  POP  BX
  POP  AX
  POPF
  RET  2
MsDosFunctionInterrupt ENDP
$EJECT

; Entry
;  BP:SI => Device header
;  DI = error code
;  AL = drive number if block device
;  AH = error info
;   if blk device and bit 7 = 1 then allocation table error

Int24ErrorHandler PROC FAR
    AND  DI, 0FFH
    CMP  DI, 12
    JBE  Int24ErrorInRange

    MOV  DI, 12

Int24ErrorInRange:
    PUSH DS
    MOV  DS, BP
    TEST WORD PTR DS:[SI+4], 8000H
    POP  DS
    JNZ  CharDeviceError

BlkDeviceError:
    TEST AH, 80H
    MOV  AL, eInvBitMap
    JNZ  SetInt24ErrorCode

    ADD  DI, OFFSET SYSDEP_CGROUP:blkToGRiDErrs
    JMP  SHORT LookupInt24ErrorCode

CharDeviceError:
    ADD  DI, OFFSET SYSDEP_CGROUP:charToGRiDErrs

LookupInt24ErrorCode:
    MOV  AL, CS:[DI]

SetInt24ErrorCode:
    MOV  CS:int24ErrorCode, AL

Int24ErrorHandlerRet:
    CMP  AL, eWriteProtect       ; Use ignore for write protect errors
    JNE  Int24PopStackRet        ; so MsDos sets buffers to not dirty

Int24IgnoreRet:
    MOV  AL, 0                   ; Ignore (No, dummy.  Not the comment.)
    IRET

Int24PopStackRet:
    MOV  AH, 2CH                 ; Do a non-disk MsDos call
    INT  fnCallInt               ; to clean up the MsDos stack

    POP  AX
    POP  AX
    POP  AX                      ; Get rid of CS,IP,flags from Int 21

    POP  AX
    POP  BX
    POP  CX
    POP  DX
    POP  SI
    POP  DI
    POP  BP
    POP  DS
    POP  ES                      ; Restore users registers

    MOV  AL, 0FFH                ; Set AL to reflect errors for FCB calls
    PUSH BP
    MOV  BP, SP                  ; Put SP into a base register
    OR   WORD PTR SS:[BP+6], 1   ; Set the carry flag for Xenix calls
    POP  BP
    IRET
Int24ErrorHandler ENDP
$EJECT

; DosDiskCallGRiDError (Make a MsDos disk call, return a GRiD error)

; This routine accepts the parameters for a limited number of MsDos calls
; that can be affected by Int24 Error situations.  The only calls that this
; routine expects to get are fcb search first (11H), some Xenix file system
; calls (39H,3AH, 3CH-43H, 4EH,4FH, 56H,57H) and load and go (4BH).  If you
; need to use this routine to handle any other Int24 error situations then
; you had better change it first !!!  The calls 11H, 4EH & 4FH have ES:DI
; being passed in with the DTA to be set by this routine.

; Entry
;  AH = MsDos call identifier
;  Other registers dependent on call

; Exit
;  Carry set => Error, with AX = error code in InteGRiD error numbers
;  No Carry  => Call was successful and registers reflect each calls results

lf        EQU 0AH
cr        EQU 0DH

kbdToDos  EQU 1
kbdToGRiD EQU 2

exitPromptMsg DB cr,lf,'Type EXIT to return to InteGRiD',cr,lf,'$'

DosDiskCallGRiDError PROC FAR
    PUSH DS
    PUSH ES
    POP  DS                       ; ES passed is used as DS for MsDos
    MOV  ES, SI                   ; SI passed is used as ES for MsDos

    PUSH ES
    PUSH SI
    PUSH DI
    PUSH DX
    PUSH CX
    PUSH BX
    PUSH AX

    CMP  AH, 4BH                  ; Is this a load and go ?
    JNE  AllOthersEntry

LoadAndGoEntry:
    CALL WaitOnDosSemaGiveMem     ; WaitOnMsDosSema, GiveMemoryBackToDos
    CALL SaveGRiDInts
    CALL RestoreDosInts
    JMP  SHORT Continue1

AllOthersEntry:
    CALL WaitOnMsDosSema

Continue1:
    POP  AX
    POP  BX
    POP  CX
    POP  DX
    POP  DI
    POP  SI
    POP  ES

    MOV  CS:int24ErrorCode, eOK   ; int24Error = eOK
    MOV  CS:lastCall, AH          ; Save last call made
    MOV  CS:stackSS, SS           ; Save stack segment
    MOV  CS:stackSP, SP           ; Save stack offset

    CMP  AH, 4BH                  ; Is this a load and go
    JNE  CheckForSettingDTA

    TEST  AL, 1
    JZ    AfterExitPrompt

    PUSH  DS
    PUSH  DX                      ; Save ptr to loadpath

    PUSH  CS
    POP   DS
    MOV   DX, OFFSET exitPromptMsg
    MOV   AH, 9                   ; Display string ending with $
    INT   fnCallInt

    POP   DX
    POP   DS

AfterExitPrompt:
    PUSH BX
    MOV  AH, 51H                  ; Get PDB of current process
    INT  fnCallInt
    XCHG AX, BX
    POP  BX

    MOV  SS, AX                   ; Set stack to PDB:100H to get around
    MOV  SP, 100H                 ; a bug in PcDos 2.x loader
    MOV  AX, 4B00H                ; Restore call to load and go
    JMP  SHORT MakeCallToMsDos

CheckForSettingDTA:
    CMP  AH, 11H                  ; If Fcb search, then need to set DTA
    JE   SetDiskXferAddr

    CMP  AH, 4EH                  ; If XnxMatchFirst, then need to set DTA
    JE   SetDiskXferAddr

    CMP  AH, 4FH                  ; If XnxMatchNext, then need to set DTA
    JNE  MakeCallToMsDos

SetDiskXferAddr:
    PUSH DS
    PUSH DX
    PUSH AX

    PUSH ES
    POP  DS                       ; DTA passed in ES:DI
    MOV  DX, DI                   ; but needs to be in DS:DX
    MOV  AH, 1AH                  ; Set DTA
    INT  fnCallInt                ; Call MsDos

    POP  AX
    POP  DX
    POP  DS

MakeCallToMsDos:
    INT  fnCallInt                ; Call MsDos

    MOV  SS, CS:stackSS           ; Restore stack segment
    MOV  SP, CS:stackSP           ; Restore stack offset

    JC   XnxFileSystemError       ; Carry may indicate Xnx call error

    CMP  CS:int24ErrorCode, eOK   ; If int24Error is still eOK then
    JE   OkayExit                 ; Done

XnxFileSystemError:
    CMP  CS:int24ErrorCode, eOK   ; If int24Error is not eOK then
    JNE  Interrupt24Error         ; Error case

    CMP  CS:lastCall, 11H         ; If call was fcb search first then
    JE   OkayExit                 ; carry has no meaning and Done

    PUSH BX
    MOV  BX, OFFSET msToGRiDErrors
    XLAT CS:BYTE PTR [BX]         ; Xlate MsDos error to InteGRiD error
    POP  BX
    JMP  SHORT ErrorExit

Interrupt24Error:
    MOV  AL, CS:int24ErrorCode

ErrorExit:
    MOV  AH, 0
    STC
    JMP  SHORT DosDiskCallExit

OkayExit:
    CLC

DosDiskCallExit:
    PUSH ES
    PUSH SI
    PUSH DI
    PUSH DX
    PUSH CX
    PUSH BX
    PUSH AX
    PUSHF

    CMP  CS:lastCall, 4BH         ; Was this a load and go ?
    JNE  AllOthersExit

LoadAndGoExit:
    CALL RestoreGRiDInts
    MOV  AX, SYSDEP_DGROUP
    MOV  ES, AX
    MOV  ES:msDosDepth, 1         ; Guarantee signal of msDosSema
    CALL TakeMemSignalDosSema     ; TakeMemoryBackFromDos, SignalMsDosSema
    JMP  SHORT Continue2

AllOthersExit:
    CALL SignalMsDosSema

Continue2:
    POPF
    POP  AX
    POP  BX
    POP  CX
    POP  DX
    POP  DI
    POP  SI
    POP  ES

    POP  DS

    RET
DosDiskCallGRiDError ENDP
$EJECT

;
;   PatchDOSInterrupts: PROCEDURE NEAR
;
;
oldMsDosIntLocOff EQU 21h * 4
oldMsDosIntLocSeg EQU oldMsDosIntLocOff + 2
MsDosErrorIntLocOff EQU 24h * 4

PatchDOSInterrupts PROC NEAR
  PUSH DS
  PUSH CS
  POP  DS           ; seg of DoNothing
  MOV  DX, OFFSET Sysdep_CGROUP:DoNothing
  MOV  AX, 2523h
  INT  21h

  MOV  AX, SYSDEP_DGROUP
  MOV  DS, AX
  MOV  DS:MsDosUserPid, 0FFFFh
  MOV  DS:MsDosDepth, 0

  CLI
  XOR  AX, AX
  MOV  DS, AX
  MOV  BX, oldMsDosIntLocOff
  MOV  AX, DS:[BX]
  MOV  CS:oldMsDosInterruptOff, AX
  MOV  AX, DS:[BX+2]
  MOV  CS:oldMsDosInterruptSeg, AX

  MOV  AX, OFFSET SYSDEP_CGROUP:MsDosFunctionInterrupt
  MOV  DS:[BX], AX
  MOV  DS:[BX+2], CS

; patch the int 24 error handler
  MOV  BX, msDosErrorIntLocOff
  MOV  AX, OFFSET SYSDEP_CGROUP:Int24ErrorHandler
  MOV  DS:[BX], AX
  MOV  DS:[BX+2], CS
  STI

  POP  DS
  RET
PatchDOSInterrupts ENDP
$EJECT


;   MsExit: PROCEDURE NEAR
;
; This program will exit InteGRiD
;
MsExit PROC NEAR
  MOV  AX, 2
  INT  10h          ; put screen in char mode (This may destroy BP)

  MOV  AX, 4c00h    ; terminate a process in MsDos
  INT  21h
MsExit ENDP


; GetBootDevice: PROCEDURE BYTE CLEAN;
;
; This routine will return the current device
; 

GetBootDevice PROC NEAR
  MOV  AH, 19h
  INT  21h         ; get the current drive
  RET
GetBootDevice ENDP
$EJECT

; SumBufferBytes: PROCEDURE (pBuf, len);
;   DCL len   WORD;
;   DCL pBuf  PTR;
;  
; This will calculate the checksum of
; a string of bytes.  It will form
; a byte result and will store it into
; loaderChecksum.
 
;          constants

evnn   EQU 0                  ; length is evnn
odd    EQU 1                  ; length is odd

len    EQU  WORD PTR [BP+6]
pBuf   EQU DWORD PTR [BP+8]


MySumBufferBytes PROC NEAR
  PUSH DS
  PUSH BP
  MOV  BP,SP
       
  MOV  CX, len                 ; get length
       
  JCXZ DoneSum                 ; done if length = 0

  MOV  AX, DS                  ; store the DS reg into ES
  MOV  ES, AX
  LDS  SI, pBuf                ; load the buffer ptr

  MOV  BL, ES:loaderChecksum   ; init checksum       

  MOV  DL, evnn                ; assume evnn
  SHR  CX,1                    ; cx := cx/2
  JNC  EvenLength

  MOV  DL, odd
  JCXZ DoLastByte              ; done if length = 1

EvenLength:
  CLD                          ; Go forward
  
CheckLoop:
  LODSW
  ADD  BL, AL                  ; add low byte
  ADD  BL, AH                  ; add high byte
  LOOP CheckLoop

  AND  DL,DL                   ; is dl = 0 ?
  JZ   StoreIt
       
DoLastByte:
  MOV  AL, BYTE PTR DS:[SI]    ; if odd then add in
  ADD  BL, AL

StoreIt:
  MOV ES:loaderChecksum, BL    ; store back the checksum

DoneSum:
  POP BP
  POP DS
  RET 6                        ; 6 bytes of parameters
MySumBufferBytes ENDP

PURGE evnn, odd, len, pBuf

Sysdep_CODE ENDS
$EJECT

  ASSUME  CS:EMS_CGROUP
  ASSUME  DS:NOTHING

EMS_CODE  SEGMENT PUBLIC 'CODE'

; NOTE: This is the only thing in the group EMS_CGROUP.
; If anything is added that changes this piece of code
; so it is not relative to zero, then it will not work.


; EmsPatcher
;
; This is the code that links calls between two EMS code groups.
; It is used by the ProcessFixups routine in the LdrDta module.

; NOTE: The position of the first two MOV instructions is known
; by some code in LdrDta and will affect things if changed !!!!

; Entry (from jump table entry)
;  DX = IP of destination

EmsPatcher PROC FAR
EmsPatchStart:
  MOV  AL, 0FFH                ; This is where the EMS slot will be patched
  MOV  CX, 0FFFFH              ; This is where the EMS address will be patched

  MOV  DI, CS:patchLevel
  CMP  DI, 16
  JB   EmsPatchOkay

  PUSH CX
  CALL OsExit

EmsPatchOkay:
  SHL  DI, 1
  SHL  DI, 1                   ; Index into array of ptrs
  ADD  DI, OFFSET retAddrStack
  POP  WORD PTR CS:[DI+0]      ; Save return IP onto ret addr "stack"
  POP  WORD PTR CS:[DI+2]      ; Save return CS onto ret addr "stack"

  PUSH CX
  PUSH DX                      ; Save address to original fixup

  PUSH AX                      ; EMS slot set above
  INT  71H                     ; CpCalls Subsystem
  DB   4EH                     ; CALL CpSetActiveSlot (Returns previous slot)

  MOV  DI, CS:patchLevel
  ADD  DI, OFFSET retSlotStack
  MOV  CS:[DI], AL             ; Save old slot onto slot "stack"

  POP  DX
  POP  CX                      ; Restore address to original fixup

  INC  CS:patchLevel

  MOV  AX, OFFSET EmsPatchRet
  PUSH CS
  PUSH AX                      ; Have called process return to EmsPatchRet
  PUSH CX
  PUSH DX                      ; Jump to original fixup
  RET

EmsPatchRet:
  DEC  CS:patchLevel

  PUSH ES                      ; Save procedure's PTR return
  PUSH BX
  PUSH DX                      ; Save procedure's DWORD return
  PUSH AX                      ; Save procedure's WORD/BYTE return

  MOV  DI, CS:patchLevel
  ADD  DI, OFFSET retSlotStack
  MOV  AL, CS:[DI]

  PUSH AX                      ; EMS slot saved above
  INT  71H                     ; CpCalls Subsystem
  DB   4EH                     ; CALL CpSetActiveSlot

  POP  AX                      ; Restore procedure's WORD/BYTE return
  POP  DX                      ; Restore procedure's DWORD return
  POP  BX
  POP  ES                      ; Restore procedure's PTR return

  MOV  DI, CS:patchLevel
  SHL  DI, 1
  SHL  DI, 1                   ; Index into array of ptrs
  ADD  DI, OFFSET retAddrStack
  PUSH WORD PTR CS:[DI+2]
  PUSH WORD PTR CS:[DI+0]
  RET
EmsPatcher ENDP

patchLevel   DW 0
retAddrStack DD 16 DUP (?)
retSlotStack DB 16 DUP (?)

EmsPatchTable:

EMS_CODE  ENDS

	END
